declare module 'node:process' {
    export = process;
}

declare module 'process' {
    import * as tty from 'node:tty';

    global {
        namespace NodeJS {
            // this namespace merge is here because these are specifically used
            // as the type for process.stdin, process.stdout, and process.stderr.
            // they can't live in tty.d.ts because we need to disambiguate the imported name.
            interface ReadStream extends tty.ReadStream {}
            interface WriteStream extends tty.WriteStream {}
        }
    }

    export = process;
}
